#ifndef _DATABASETREE_H
#define _DATABASETREE_H

#include <QtGui>
#include <QtSql>
#include <QMenu>
#include <QAction>

class DatabaseTree : public QTreeWidget
{
	Q_OBJECT 

	public:
		DatabaseTree(QWidget* parent=0);
		//DatabaseTree(Database* database, QWidget* parent=0);
		virtual ~DatabaseTree();

	public:
		void MakeTreeView();
		void ReadEachTable(QSqlDatabase* db, QTreeWidgetItem* databaseName);
		void CreateActions();

	public slots:
		
	protected:
		void contextMenuEvent(QContextMenuEvent *event);

	public:
		QAction* GetViewDataAction() const;
		QAction* GetCreateTableAction() const;
		QAction* GetAlterTableAction() const;
		QAction* GetDropTableAction() const;
		QAction* GetEmptyTableAction() const;
		QAction* GetRenameTableAction() const;
		QAction* GetCreateStoredProcAction() const;
		QAction* GetAlterStoredProcAction() const;
		QAction* GetDropStoredProcAction() const;
		QAction* GetCreateFuncAction() const;
		QAction* GetAlterFuncAction() const;   
		QAction* GetDropFuncAction() const;  
		QAction* GetManageColumnAction() const;
		QAction* GetCreateViewAction() const;
		QAction* GetAlterViewAction() const;   
		QAction* GetDropViewAction() const;   
		QAction* GetRenameViewAction() const;
		QAction* GetCreateTriggerAction() const;
		QAction* GetAlterTriggerAction() const;   
		QAction* GetDropTriggerAction() const;
		QAction* GetRelationShipAction() const;

	private:
		QAction* createTableAction;
		QAction* alterTableAction;
		QAction* dropTableAction;
		QAction* emptyTableAction;
		QAction* renameTableAction;
		QAction* viewDataAction;
		QAction* createStoredProcAction;
		QAction* alterStoredProcAction;
		QAction* dropStoredProcAction;
		QAction* createFuncAction;
		QAction* alterFuncAction;   
		QAction* dropFuncAction;   
		QAction* manageColumnAction;
		QAction* createViewAction;
		QAction* alterViewAction;   
		QAction* dropViewAction;   
		QAction* renameViewAction;
		QAction* createTriggerAction;
		QAction* alterTriggerAction;   
		QAction* dropTriggerAction;
		QAction* exportToXMLAction;
		QAction* createDatabaseAction;
		QAction* dropDatabaseAction;
		QAction* relationshipAction;
};	
/*
inline Database* DatabaseTree::GetDatabase() const
{
	return this->database;
}
*/

inline QAction* DatabaseTree::GetViewDataAction() const
{
	return this->viewDataAction;
}

inline QAction* DatabaseTree::GetCreateTableAction() const
{
	return this->createTableAction;
}

inline QAction* DatabaseTree::GetAlterTableAction() const
{
	return this->alterTableAction;
}

inline QAction* DatabaseTree::GetDropTableAction() const
{
	return this->dropTableAction;
}

inline QAction* DatabaseTree::GetEmptyTableAction() const
{
	return this->emptyTableAction;
}

inline QAction* DatabaseTree::GetRenameTableAction() const
{
	return this->renameTableAction;
}

inline QAction* DatabaseTree::GetCreateStoredProcAction() const
{
	return this->createStoredProcAction;
}

inline QAction* DatabaseTree::GetAlterStoredProcAction() const
{
	return this->alterStoredProcAction;
}

inline QAction* DatabaseTree::GetDropStoredProcAction() const
{
	return this->dropStoredProcAction;
}

inline QAction* DatabaseTree::GetCreateFuncAction() const
{
	return this->createFuncAction;
}

inline QAction* DatabaseTree::GetAlterFuncAction() const
{
	return this->alterFuncAction;
}

inline QAction* DatabaseTree::GetDropFuncAction() const
{
	return this->dropFuncAction;
}

inline QAction* DatabaseTree::GetManageColumnAction() const
{
	return this->manageColumnAction;
}

inline QAction* DatabaseTree::GetCreateViewAction() const
{
	return this->createViewAction;
}

inline QAction* DatabaseTree::GetAlterViewAction() const   
{
	return this->alterViewAction;
}

inline QAction* DatabaseTree::GetDropViewAction() const  
{
	return this->dropViewAction;
}

inline QAction* DatabaseTree::GetRenameViewAction() const
{
	return this->renameViewAction;
}

inline QAction* DatabaseTree::GetCreateTriggerAction() const
{
	return this->createTriggerAction;
}

inline QAction* DatabaseTree::GetAlterTriggerAction() const   
{
	return this->alterTriggerAction;
}

inline QAction* DatabaseTree::GetDropTriggerAction() const
{
	return this->dropTriggerAction;
}

inline QAction* DatabaseTree::GetRelationShipAction() const
{
	return this->relationshipAction;
}

#endif //_DATABASETREE_H
